local TABAS_Utils = require("TABAS_Utils")

local original_getInfoPanelFlagsGeneral = ISMoveableSpriteProps.getInfoPanelFlagsGeneral
function ISMoveableSpriteProps:getInfoPanelFlagsGeneral( _square, _object, _player, _mode )
    original_getInfoPanelFlagsGeneral(self, _square, _object, _player, _mode )
    if _object and TABAS_Utils.isBathObject(_object) then
        local mainObj = TABAS_Utils.getFullyBathObject(_object)
        local tfc = TABAS_Utils.getTfcObjectOnBathObject(mainObj)
        if tfc then
            if _mode and _mode == "rotate" then
                InfoPanelFlags.canRotate = false
                InfoPanelFlags.hasWater = true
            end
            if _mode == "scrap" then
                InfoPanelFlags.hasWater = true
            end
            if _mode and _mode =="pickup" then
                InfoPanelFlags.hasWater = true
            end
        end
    end
end

local original_canPickUpMoveableInternal = ISMoveableSpriteProps.canPickUpMoveableInternal
function ISMoveableSpriteProps:canPickUpMoveableInternal( _character, _square, _object, _isMulti)
    local canPickUp = original_canPickUpMoveableInternal(self, _character, _square, _object, _isMulti)
    if _object and TABAS_Utils.isBathObject(_object) then
        local mainObj = TABAS_Utils.getFullyBathObject(_object)
        local tfc = TABAS_Utils.getTfcObjectOnBathObject(mainObj)
        canPickUp = tfc == nil
    end
    return canPickUp
end

-- local original_pickUpMoveableInternal = ISMoveableSpriteProps.pickUpMoveableInternal
-- function ISMoveableSpriteProps:pickUpMoveableInternal( _character, _square, _object, _sprInstance, _spriteName, _createItem, _rotating )
--     if _object and TABAS_Utils.isBathObject(_object)then
--         local mainObj  = TABAS_Utils.getFullyBathObject(_object)
--         local tfc = TABAS_Utils.getTfcObjectOnBathObject(mainObj)
--         if tfc then
--             tfc:remove()
--         end
--     end
--     return original_pickUpMoveableInternal(self, _character, _square, _object, _sprInstance, _spriteName, _createItem, _rotating)
-- end

local original_canRotateMoveable = ISMoveableSpriteProps.canRotateMoveable
function ISMoveableSpriteProps:canRotateMoveable( _square, _object, _origProps)
    local canRotate = original_canRotateMoveable(self, _square, _object, _origProps)
    if _object and TABAS_Utils.isBathObject(_object) then
        local mainObj = TABAS_Utils.getFullyBathObject(_object)
        local tfc = TABAS_Utils.getTfcObjectOnBathObject(mainObj)
        canRotate = tfc == nil
    end
    return canRotate
end

local original_canScrapObjectInternal = ISMoveableSpriteProps.canScrapObjectInternal
function ISMoveableSpriteProps:canScrapObjectInternal(_result, _object)
    local canScrap = original_canScrapObjectInternal(self, _result, _object)
    if _object and TABAS_Utils.isBathObject(_object) then
        local mainObj = TABAS_Utils.getFullyBathObject(_object)
        local tfc = TABAS_Utils.getTfcObjectOnBathObject(mainObj)
        canScrap = tfc == nil
    end
    return canScrap
end

-- local original_canPlaceMoveableInternal = ISMoveableSpriteProps.canPlaceMoveableInternal
-- function ISMoveableSpriteProps:canPlaceMoveableInternal(_character, _square, _item, _forceTypeObject)
--     local canPlace = original_canPlaceMoveableInternal(self, _character, _square, _item, _forceTypeObjects)
--     if _forceTypeObject and TABAS_Utils.isBathObject(_forceTypeObjects) then
--         local mainObj = TABAS_Utils.getFullyBathObject(_forceTypeObjects)
--         local tfc = TABAS_Utils.getTfcObjectOnBathObject(mainObj)
--         canPlace = tfc == nil
--     end
--     return canPlace
-- end